<?php

/**
 * DuoLamPHP FrameWork 
 * http://www.imoi.cn
 *
 * Copyright (c) 2011 Mo Yi
 * 
 * @author Mo Yi root@imoi.cn
 */
 
!defined('DL_Root') && exit ( 'Access Denied!' );

class DDbcommand extends DDbBase{

	public $dbc;

	public $cache;

	private $_sql;

	private static $_cacheTime,$_pdoMode;

	public function __construct()
	{
		parent::__construct();
		$this->dbc = $this->returnDb();
		$this->cache = $this->returnCache();
		$this->_getPdoCache();
	}

	public function setPdoCache(){}

	private function _getPdoCache($params=array())
	{
		$methods = get_class_methods($this);
		if(in_array('setPdoCache', $methods))
		{
			$params = $this->setPdoCache();
		}
		self::$_cacheTime = empty($params['cacheTime']) ? 0 : $params['cacheTime'];
		self::$_pdoMode = empty($params['pdoMode']) ? PDO::FETCH_ASSOC : $params['pdoMode'];
	}

	public function sqlCommand($sql=null,$execution = false)
	{
		$this->_sql = null;
		$this->_setSql($sql);
		if($execution){
			if(preg_match('/UPDATE/i',$sql) or preg_match('/INSERT/i',$sql) or preg_match('/DELETE/i',$sql))
			{
				return $this->exec($sql);
			}
			else if(preg_match('/SELECT/i',$sql))
			{
				return $this->_fetch($this->_sql,1,self::$_cacheTime,self::$_pdoMode);
			}
			else
			{
				$this->_sql = 'SELECT * FROM '.$sql;
				return $this->_fetch($this->_sql,1,self::$_cacheTime,self::$_pdoMode);
			}
		}
		return $this;
	}
	
	public function execute($sql=null)
	{
		return $this->exec(empty($sql) ? $this->_sql : $sql);
	}

	public function fetch($sql=null)
	{
		return $this->_fetch(empty($sql) ? $this->_sql : $sql,0,self::$_cacheTime,self::$_pdoMode);
	}

	public function fetchAll($sql=null)
	{
		return $this->_fetch(empty($sql) ? $this->_sql : $sql,1,self::$_cacheTime,self::$_pdoMode);
	}

	public function count($sql = null)
	{
		return empty($sql) ? $this->rowCount($this->_sql) : $this->sqlCount($sql);
	}

	/* C */
	public function select($select = '*')
	{
		$this->_setSql('SELECT '.$select);
		return $this;
	}

	public function from($from)
	{
		$this->_setSql(' FROM '.$from);
		return $this;
	}

	public function join($type='LEFT',$table,$on)
	{
		$sql = ' ' . $type . ' JOIN ' . $table . ' ON ' . $on;
		$this->_setSql($sql);
		return $this;
	}
	
	public function where($where)
	{	
		$sql = $where;
		if(is_array($where))
		{
			$sql = '';
			foreach($where as $field => $value)
			{
				$sql .= '`'.$field ."`='". $value ."' AND ";
			}
			$sql = substr($sql,0,-4);
		}
		$this->_setSql(' WHERE '.$sql);
		return $this;
	}

	public function group($group)
	{
		$this->_setSql(' GROUP BY '. $group);
		return $this;
	}

	public function having($having)
	{
		$this->_setSql(' HAVING ' . $having);
		return $this;
	}

	public function order($order)
	{
		$this->_setSql(' ORDER BY '. $order);
		return $this;
	}

	public function limit($limit)
	{
		$this->_setSql(' LIMIT '. $limit);
		return $this;
	}

	/*
	 * RUD
	 */
	public function insert($table,$data)
	{
		$params = array(
			'table'=>$table,
			'field'=>$data,
		);
		return $this->_insert($params);	
	}

	public function update($table,$data,$where)
	{
		$params = array(
			'table'=>$table,
			'field'=>$data,
			'where'=>$where
		);
		return $this->_update($params);
	}

	public function delete($table,$where)
	{
		$params = array(
			'table'=>$table,
			'where'=>$where
		);
		return $this->_delete($params);
	}

	private function _setSql($sql)
	{
		$this->_sql .= empty($sql) ? null : $sql;
	}

	/* Cache */
	public function setCache($time)
	{
		self::$_cacheTime = $time;
		echo self::$_cacheTime;
		return $this;
	}

	public function clearCache($sql='')
	{
		$sql = empty($sql) ? $this->_sql : $sql;
		return $this->cache->del($sql);
	}

	public function clearCacheAll()
	{
		$this->cache->delAll();
	}

	public function getSql()
	{
		return self::setTableSuffix($this->_sql);
	}

}
?>